<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name')); ?></title>
    <style>
        body {
            font-family: 'Roboto', Helvetica, Arial, sans-serif;
            color: #4d5155;
            font-size: 14px;
        }
        table {
            border-collapse: collapse;
            width: 100%;
        }
        td, th {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
        }
        .header {
            height: 50px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid #4f46e5;
        }
        .header h1 {
            font-size: 44px;
            color: #333332;
        }
        .section {
            width: 100%;
            margin-top: 50px;
        }
        .section.no-margin {
            margin-top: 10px;
            margin-bottom: 20px;
        }
        .label {
            white-space: nowrap;
            color: #8c8d8e;
            margin-top: 30px;
        }
    </style>
</head>
<body>
<div class="header">
    <h1><?php echo e(__('List of customers')); ?></h1>
</div>

<div class="section no-margin">
    <span class="label"><?php echo e(__('Report generated by ') . config('app.name') . __(' ') . date('Y-m-d h:i A')); ?></span>
</div>

<table>
    <thead>
    <tr>
        <th><?php echo e(__('Name')); ?></th>
        <th><?php echo e(__('Email')); ?></th>
        <th><?php echo e(__('Phone')); ?></th>
        <th><?php echo e(__('Address')); ?></th>
        <th><?php echo e(__('Status')); ?></th>
        <th><?php echo e(__('Member since')); ?></th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($user->name); ?></td>
            <td><?php echo e($user->email); ?></td>
            <td><?php echo e($user->detail->phone); ?></td>
            <td><?php echo e($user->detail->address); ?></td>
            <td><?php echo e($user->detail->status); ?></td>
            <td><?php echo e(date('Y-m-d', strtotime($user->created_at))); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>
<?php /**PATH /Users/ahsan/Herd/betternet4/resources/views/reports/users.blade.php ENDPATH**/ ?>